# Student challenge

Original authors: Cédric Allain - Alexis G. - Clotilde Miura - Artem Muliukov

As part of the Data Camp course, within the [Data Science Masters at Institut Polytechnique
de Paris in collaboration with University of
Paris-Saclay](https://datascience-x-master-paris-saclay.fr/le-master/structure-des-enseignements/),
students were required to build a data challenge addressing some social/science/business
problem using data obtained from external sources. This is one example of a student
challenge, showcased on the ramp.studio server.

# Prediction "Brevet des collèges" success rate

Every year in France, more than 800 000 students aged around 15 take a compulsory national exam, the "Brevet des collèges" which marks the end of four years of studies. The national average is 86.5% of success.  This project aims at predicting the average success rate at the brevet des colleges for each french public college and  identifying factors of the success of the best colleges and the degrees of flexibility of the government to reduce inequalities.

## Get started

The [starting kit notebook](https://github.com/ramp-kits/brevet/blob/master/brevet_starting_kit.ipynb)
provides more details on this challenge and exploratory analysis on the data used.

To get started on this challenge follow the instructions
[here](https://paris-saclay-cds.github.io/ramp-docs/ramp-workflow/stable/using_kits.html).

**WARNING:** The maps are not visible in the notebook on github because they are dynamic.
So you need to run the notebook locally and  make sure you have an internet connection
because they need to access some url on [FranceGeoJson](https://france-geojson.gregoiredavid.fr/)
where some dynamic maps are held. To see the notebook correctly compiled with
the dynamics maps, please click [here](https://nbviewer.jupyter.org/github/ramp-kits/brevet/blob/master/brevet_starting_kit.ipynb).
